(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     16457,        653]*)
(*NotebookOutlinePosition[     17302,        680]*)
(*  CellTagsIndexPosition[     17258,        676]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \( (*\ Example\ 6.3  .1 : \ Error\ analysis\ with\ n = 
        2\ \nusing\ Gauss\ quadrature\ \ *) \n\(k[x_, \ s_] := \ 
        Exp[x\ s];\)\), "\n", 
    \(\(f[x_] := \ 1 - \ \((Exp[x] - 1)\)/\((2\ x)\);\)\), "\n", 
    \(\(x1 = 0.2113248654;\)\), "\n", 
    \(\(x2 = 0.7886751346;\)\), "\n", 
    \(\(A1 = 0.5;\)\), "\n", 
    \(\(A2 = 0.5;\)\), "\n", 
    \(\(\[Lambda] = 0.5;\)\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(1 - A1*\[Lambda]*k[x1, x1] // N\)], "Input"],

Cell[BoxData[
    \(0.738582403159967793`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(-A2\)*\[Lambda]*k[x1, x2] // N\)], "Input"],

Cell[BoxData[
    \(\(-0.295340103215526994`\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(1 - A2*\[Lambda]*k[x2, x2] // N\)], "Input"],

Cell[BoxData[
    \(0.534333652217229904`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(m = {{1 - A1*\[Lambda]*k[x1, x1], \(-A2\)*\[Lambda]*k[x1, x2]\ }, \n
          \t\t{\(-A2\)*\[Lambda]*k[x1, x2], \ 1 - A2*\[Lambda]*k[x2, x2]}} // 
        N\)], "Input"],

Cell[BoxData[
    \({{0.738582403159967793`, \(-0.295340103215526994`\)}, {
        \(-0.295340103215526994`\), 0.534333652217229904`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[m]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0.738582403159967793`", \(-0.295340103215526994`\)},
            {\(-0.295340103215526994`\), "0.534333652217229904`"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(d = Det[m]\)], "Input"],

Cell[BoxData[
    \(0.307423656376486009`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x1] // N\)], "Input"],

Cell[BoxData[
    \(0.443242043277690278`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x2] // N\)], "Input"],

Cell[BoxData[
    \(0.238926712137671914`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(d1 = 
      Det[{{0.443242043277690278`, \ \(-0.295340103215526994`\)}, \n
          \t\t{0.238926712137671914`, \ 0.534333652217229904`}}]\)], "Input"],

Cell[BoxData[
    \(0.307403779624482265`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(d2 = 
      Det[{{0.738582403159967793`, 0.443242043277690278`}, \n
          \t\t{\(-0.295340103215526994`\), \ 0.238926712137671914`}}]\)], 
  "Input"],

Cell[BoxData[
    \(0.307374216040845693`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi]1tilde = d1/d\)], "Input"],

Cell[BoxData[
    \(0.999935344103840328`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Phi]2tilde = d2/d\)], "Input"],

Cell[BoxData[
    \(0.999839178493213509`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ 
      The\ approximate\ solution\ \[CurlyPhi]tilde[x]\ is\ denoted\ by\ 
        \[CurlyPhi]tilde\ \ and\ also\ by\ \[CurlyPhi]\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi]tilde = 
      0.25\ *\ \((Exp[x1\ x]*d1/d + Exp[x2\ x]*d2/d)\)\  + f[x]\)], "Input"],

Cell[BoxData[
    RowBox[{"1", "+", 
      RowBox[{
        StyleBox["0.25`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"0.999935344103840328`", " ", 
              SuperscriptBox["E", 
                RowBox[{
                  StyleBox["0.211324865399999994`",
                    StyleBoxAutoDelete->True,
                    PrintPrecision->10], " ", "x"}]]}], "+", 
            RowBox[{"0.999839178493213509`", " ", 
              SuperscriptBox["E", 
                RowBox[{
                  StyleBox["0.788675134600000049`",
                    StyleBoxAutoDelete->True,
                    PrintPrecision->10], " ", "x"}]]}]}], ")"}]}], "-", 
      \(\(\(-1\) + E\^x\)\/\(2\ x\)\)}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Limit[\(\(-1\) + E\^x\)\/\(2\ x\), \ x -> 0]\)], "Input"],

Cell[BoxData[
    \(1\/2\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{\(\[CurlyPhi][x_]\), ":=", 
        RowBox[{"1", "+", 
          RowBox[{
            StyleBox["0.25`",
              StyleBoxAutoDelete->True,
              PrintPrecision->2], " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{"0.999935344103840328`", " ", 
                  SuperscriptBox["E", 
                    RowBox[{
                      StyleBox["0.211324865399999994`",
                        StyleBoxAutoDelete->True,
                        PrintPrecision->10], " ", "x"}]]}], "+", 
                RowBox[{"0.999839178493213509`", " ", 
                  SuperscriptBox["E", 
                    RowBox[{
                      StyleBox["0.788675134600000049`",
                        StyleBoxAutoDelete->True,
                        PrintPrecision->10], " ", "x"}]]}]}], ")"}]}], "-", 
          \(\(\(-1\) + E\^x\)\/\(2\ x\)\)}]}], ";", "\n", 
      \(Limit[\[CurlyPhi][x], \ x -> 0]\)}]], "Input"],

Cell[BoxData[
    \(0.999943630649263504`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ 
      Exact\ solution\ is\ \[Phi][x] = 
        \(1. \ So\ the\ error\ is\n\t\[Phi][x]\  - \ \[CurlyPhi][x] = 
          \(1 - 999944 = \(0.000056\ at\ x = 0\)\)\)\ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi][x1]\)], "Input"],

Cell[BoxData[
    \(0.999935344103840151`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi][x2]\)], "Input"],

Cell[BoxData[
    \(0.999839178493213509`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ So\ the\ error\ at\ x1\ is\ equal\ to\ 0.000065, \ 
      and\ at\ x2\ the\ error\ is\ 0.000161\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi][1]\)], "Input"],

Cell[BoxData[
    \(0.999698836105151578`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\( (*\ So\ the\ error\ at\ x = 1\ is\ 0.000301\ \ *) \n (*\ 
      Now\ we\ find\ B\ \ which\ comes\ from\ the\ elements\ of\ d, \ 
      by\ taking\ the\ ratio\ of\ \((d11 - d12)\)\ and\ d\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(d\)], "Input"],

Cell[BoxData[
    \(0.307423656376486009`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(m\)], "Input"],

Cell[BoxData[
    \({{0.738582403159967793`, \(-0.295340103215526994`\)}, {
        \(-0.295340103215526994`\), 0.534333652217229904`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(m[\([1, 1]\)]\)], "Input"],

Cell[BoxData[
    \(0.738582403159967793`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(m[\([1, 2]\)]\)], "Input"],

Cell[BoxData[
    \(\(-0.295340103215526994`\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((m[\([1, 1]\)] - m[\([1, 2]\)])\)/d\)], "Input"],

Cell[BoxData[
    \(3.36318459861560858`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ So\ we\ take\ B = 3.4\ \ *) \nSeries[f[x], {\ x, 0, 6}]\)\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \(1\/2\), "-", \(x\/4\), "-", \(x\^2\/12\), "-", \(x\^3\/48\), "-", 
        \(x\^4\/240\), "-", \(x\^5\/1440\), "-", \(x\^6\/10080\), "+", 
        InterpretationBox[\(O[x]\^7\),
          SeriesData[ x, 0, {}, 0, 7, 1]]}],
      SeriesData[ x, 0, {
        Rational[ 1, 2], 
        Rational[ -1, 4], 
        Rational[ -1, 12], 
        Rational[ -1, 48], 
        Rational[ -1, 240], 
        Rational[ -1, 1440], 
        Rational[ -1, 10080]}, 0, 7, 1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[%, x]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \(-\(1\/4\)\), "-", \(x\/6\), "-", \(x\^2\/16\), "-", \(x\^3\/60\), 
        "-", \(x\^4\/288\), "-", \(x\^5\/1680\), "+", 
        InterpretationBox[\(O[x]\^6\),
          SeriesData[ x, 0, {}, 0, 6, 1]]}],
      SeriesData[ x, 0, {
        Rational[ -1, 4], 
        Rational[ -1, 6], 
        Rational[ -1, 16], 
        Rational[ -1, 60], 
        Rational[ -1, 288], 
        Rational[ -1, 1680]}, 0, 6, 1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[%, x]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \(-\(1\/6\)\), "-", \(x\/8\), "-", \(x\^2\/20\), "-", \(x\^3\/72\), 
        "-", \(x\^4\/336\), "+", 
        InterpretationBox[\(O[x]\^5\),
          SeriesData[ x, 0, {}, 0, 5, 1]]}],
      SeriesData[ x, 0, {
        Rational[ -1, 6], 
        Rational[ -1, 8], 
        Rational[ -1, 20], 
        Rational[ -1, 72], 
        Rational[ -1, 336]}, 0, 5, 1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[%, x]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \(-\(1\/8\)\), "-", \(x\/10\), "-", \(x\^2\/24\), "-", \(x\^3\/84\), 
        "+", 
        InterpretationBox[\(O[x]\^4\),
          SeriesData[ x, 0, {}, 0, 4, 1]]}],
      SeriesData[ x, 0, {
        Rational[ -1, 8], 
        Rational[ -1, 10], 
        Rational[ -1, 24], 
        Rational[ -1, 84]}, 0, 4, 1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[%, x]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(-\(1\/10\)\), "-", \(x\/12\), "-", \(x\^2\/28\), "+", 
        InterpretationBox[\(O[x]\^3\),
          SeriesData[ x, 0, {}, 0, 3, 1]]}],
      SeriesData[ x, 0, {
        Rational[ -1, 10], 
        Rational[ -1, 12], 
        Rational[ -1, 28]}, 0, 3, 1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(n0 = Limit[f[x], \ x -> 0] // N\)], "Input"],

Cell[BoxData[
    \(0.5`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/4 + 1/6 + 1/16 + 1/60 + 1/288 + 1/1680 // N\)], "Input"],

Cell[BoxData[
    \(0.499900793650793673`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ So\ take\ n1 = 0.5\ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/6 + 1/8 + 1/20 + 1/72 + 1/336 // N\)], "Input"],

Cell[BoxData[
    \(0.358531746031746045`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ so\ takr\ n2 = 0.36\ \ *) \)], "Input"],

Cell[BoxData[
    \(Clear[n1, n2]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/8 + 1/10 + 1/24 + 1/84 // N\)], "Input"],

Cell[BoxData[
    \(0.278571428571428558`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ so\ take\ n3 = 0.28\ *) \n1/10 + 1/12 + 1/28 // N\)\)], "Input"],

Cell[BoxData[
    \(0.219047619047619068`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ so\ take\ n4 = 0.22\ \ *) \)], "Input"],

Cell[BoxData[
    \(n0 = 0.5; n1 = 0.5; n2 = 0.36; n3 = 0.28; n4 = 0.22; \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[k[x, s], x]\)], "Input"],

Cell[BoxData[
    \(E\^\(s\ x\)\ s\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[%, x]\)], "Input"],

Cell[BoxData[
    \(E\^\(s\ x\)\ s\^2\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[%, x]\)], "Input"],

Cell[BoxData[
    \(E\^\(s\ x\)\ s\^3\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[%, x]\)], "Input"],

Cell[BoxData[
    \(E\^\(s\ x\)\ s\^4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(m0 = E; mx1 = E; mx2 = E; mx3 = E; mx4 = E; \nmy1 = E; \ my2 = E; \ 
    my3 = E; my4 = E; \n
    p4 = n0*my4 + c14*n1*my3 + c24*n2*my2 + c34*n3*my3 + n4*my4\)], "Input"],

Cell[BoxData[
    \(\(1.95716291649051239`\[InvisibleSpace]\) + 1.35914091422952254`\ c14 + 
      0.978581458245256285`\ c24 + 0.761118911968532607`\ c34\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ 
      To\ find\ max\ of\ \[CurlyPhi]tilde\ over\ the\ interval\ \((0, 1)\), \n
      \twrite\ \[CurlyPhi]tilde = g[x] + h[x], \ 
      then\ max\[CurlyPhi]tilde = \(g[0] = lim\ h[0] as\ x -> 0\)\ *) \)], 
  "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(\[CurlyPhi][x_]\), ":=", 
        RowBox[{"1", "+", 
          RowBox[{
            StyleBox["0.25`",
              StyleBoxAutoDelete->True,
              PrintPrecision->2], " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{"0.999935344103840328`", " ", 
                  SuperscriptBox["E", 
                    RowBox[{
                      StyleBox["0.211324865399999994`",
                        StyleBoxAutoDelete->True,
                        PrintPrecision->10], " ", "x"}]]}], "+", 
                RowBox[{"0.999839178493213509`", " ", 
                  SuperscriptBox["E", 
                    RowBox[{
                      StyleBox["0.788675134600000049`",
                        StyleBoxAutoDelete->True,
                        PrintPrecision->10], " ", "x"}]]}]}], ")"}]}], "-", 
          \(\(\(-1\) + E\^x\)\/\(2\ x\)\)}]}], ";"}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(g[x_]\), ":=", 
        RowBox[{
          StyleBox["0.25`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2], " ", 
          RowBox[{"(", " ", 
            RowBox[{
              SuperscriptBox["E", 
                RowBox[{
                  StyleBox["0.211324865399999994`",
                    StyleBoxAutoDelete->True,
                    PrintPrecision->10], " ", "x"}]], "+", " ", 
              SuperscriptBox["E", 
                RowBox[{
                  StyleBox["0.788675134600000049`",
                    StyleBoxAutoDelete->True,
                    PrintPrecision->10], " ", "x"}]]}], ")"}]}]}], ";", "\n", 
      \(h[x_] := 1 - \(\(-1\) + E\^x\)\/\(2\ x\)\), ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(0.25*\((Exp[0.212] + Exp[0.789])\)\)], "Input"],

Cell[BoxData[
    \(0.85933550405981407`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Limit[h[x], \ x -> 0]\)], "Input"],

Cell[BoxData[
    \(1\/2\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(max\[CurlyPhi]tilde = 
      0.25*\((Exp[0.212] + Exp[0.789])\) + Limit[h[x], \ x -> 0]\)], "Input"],

Cell[BoxData[
    \(1.35933550405981407`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ so\ we\ take\ S = 1.4\ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((1.4 + \((E*3.4*0.5*\(+1\))\)*0.5*\((1/4320)\)*22)\)/
        \((1 - \((E*3.4*0.5 + 1)\)*0.5*\((1/4320)\)*60)\) // N\)], "Input"],

Cell[BoxData[
    \(1.46911389656157194`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(0.5*\((1 + \((0.5)\) \((3.4)\) \((E)\) \((1)\))\)*\((1/4320)\) 
        \((22 + \((60)\) \((1.46911)\))\) // N\)], "Input"],

Cell[BoxData[
    \(0.0716600407545289286`\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{542, 429},
WindowMargins->{{125, Automatic}, {Automatic, 10}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 416, 9, 155, "Input"],

Cell[CellGroupData[{
Cell[2158, 62, 64, 1, 27, "Input"],
Cell[2225, 65, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2317, 71, 65, 1, 27, "Input"],
Cell[2385, 74, 60, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2482, 80, 64, 1, 27, "Input"],
Cell[2549, 83, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2641, 89, 190, 3, 43, "Input"],
Cell[2834, 94, 149, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3020, 101, 46, 1, 27, "Input"],
Cell[3069, 104, 247, 6, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3353, 115, 43, 1, 27, "Input"],
Cell[3399, 118, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3491, 124, 43, 1, 27, "Input"],
Cell[3537, 127, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3629, 133, 43, 1, 27, "Input"],
Cell[3675, 136, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3767, 142, 172, 3, 59, "Input"],
Cell[3942, 147, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4034, 153, 173, 4, 59, "Input"],
Cell[4210, 159, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4302, 165, 57, 1, 27, "Input"],
Cell[4362, 168, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4454, 174, 52, 1, 27, "Input"],
Cell[4509, 177, 55, 1, 26, "Output"]
}, Open  ]],
Cell[4579, 181, 173, 3, 43, "Input"],

Cell[CellGroupData[{
Cell[4777, 188, 116, 2, 27, "Input"],
Cell[4896, 192, 795, 20, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5728, 217, 77, 1, 42, "Input"],
Cell[5808, 220, 38, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5883, 226, 988, 23, 119, "Input"],
Cell[6874, 251, 55, 1, 26, "Output"]
}, Open  ]],
Cell[6944, 255, 207, 4, 43, "Input"],

Cell[CellGroupData[{
Cell[7176, 263, 48, 1, 27, "Input"],
Cell[7227, 266, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7319, 272, 48, 1, 27, "Input"],
Cell[7370, 275, 55, 1, 26, "Output"]
}, Open  ]],
Cell[7440, 279, 140, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[7605, 285, 47, 1, 27, "Input"],
Cell[7655, 288, 55, 1, 26, "Output"]
}, Open  ]],
Cell[7725, 292, 229, 3, 59, "Input"],

Cell[CellGroupData[{
Cell[7979, 299, 34, 1, 27, "Input"],
Cell[8016, 302, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8108, 308, 34, 1, 27, "Input"],
Cell[8145, 311, 149, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8331, 318, 46, 1, 27, "Input"],
Cell[8380, 321, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8472, 327, 46, 1, 27, "Input"],
Cell[8521, 330, 60, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8618, 336, 70, 1, 27, "Input"],
Cell[8691, 339, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8782, 345, 100, 2, 43, "Input"],
Cell[8885, 349, 529, 14, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9451, 368, 40, 1, 27, "Input"],
Cell[9494, 371, 482, 13, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10013, 389, 40, 1, 27, "Input"],
Cell[10056, 392, 431, 12, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10524, 409, 40, 1, 27, "Input"],
Cell[10567, 412, 384, 11, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10988, 428, 40, 1, 27, "Input"],
Cell[11031, 431, 323, 8, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11391, 444, 64, 1, 27, "Input"],
Cell[11458, 447, 38, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11533, 453, 78, 1, 27, "Input"],
Cell[11614, 456, 55, 1, 26, "Output"]
}, Open  ]],
Cell[11684, 460, 61, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[11770, 465, 69, 1, 27, "Input"],
Cell[11842, 468, 55, 1, 26, "Output"]
}, Open  ]],
Cell[11912, 472, 64, 1, 27, "Input"],
Cell[11979, 475, 46, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[12050, 480, 62, 1, 27, "Input"],
Cell[12115, 483, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12207, 489, 91, 1, 43, "Input"],
Cell[12301, 492, 55, 1, 26, "Output"]
}, Open  ]],
Cell[12371, 496, 64, 1, 27, "Input"],
Cell[12438, 499, 86, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[12549, 504, 46, 1, 27, "Input"],
Cell[12598, 507, 48, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12683, 513, 40, 1, 27, "Input"],
Cell[12726, 516, 51, 1, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12814, 522, 40, 1, 27, "Input"],
Cell[12857, 525, 51, 1, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12945, 531, 40, 1, 27, "Input"],
Cell[12988, 534, 51, 1, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13076, 540, 190, 3, 75, "Input"],
Cell[13269, 545, 168, 2, 26, "Output"]
}, Open  ]],
Cell[13452, 550, 241, 5, 59, "Input"],
Cell[13696, 557, 938, 22, 101, "Input"],
Cell[14637, 581, 758, 19, 64, "Input"],

Cell[CellGroupData[{
Cell[15420, 604, 67, 1, 27, "Input"],
Cell[15490, 607, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15581, 613, 54, 1, 27, "Input"],
Cell[15638, 616, 38, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15713, 622, 120, 2, 43, "Input"],
Cell[15836, 626, 54, 1, 26, "Output"]
}, Open  ]],
Cell[15905, 630, 64, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[15994, 635, 151, 2, 59, "Input"],
Cell[16148, 639, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16239, 645, 143, 2, 59, "Input"],
Cell[16385, 649, 56, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

